/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;


import java.util.Set;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.PtrArrayReplacer;
import cfg.Application;
import cfg.function.PrgFunction;
import cfg.function.argument.ActualArgumentInserter;
import cfg.function.argument.ArgumentPtrReplacer;
import cfg.function.argument.EspEbpReplacer;
import cfg.function.argument.FunctionArgumentCounter;

public class FunctionRecovery extends Phase {

  public FunctionRecovery(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "parameter handling, replacement of stack with arrays";
  }

  @Override
  public boolean process(Application app) {
    FunctionArgumentCounter.process(app.getFunctions());
    for (PrgFunction func : app.getFunctions()) {
      Set<Long> directOffsets = EspEbpReplacer.process(func);
      Set<Long> argOffsets = ActualArgumentInserter.process(func);
      directOffsets.addAll(argOffsets);
      PtrArrayReplacer.process(func, directOffsets);
    }

    ArgumentPtrReplacer.process(app.getFunctions());

    upcompiler.phase(new VariableLinker(upcompiler, true, false), app);
    return true;
  }
  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }


}
