/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.UnlinkedPhiDeleter;
import cfg.Application;
import cfg.function.argument.FuncReturnAppend;
import cfg.linker.FunctionLinker;
import cfg.linker.ReturnValueInserter;

public class FunctionVariableLinker extends Phase {

  public FunctionVariableLinker(Upcompiler upcompiler) {
    super(upcompiler);
    // TODO Auto-generated constructor stub
  }

  @Override
  public String getDescription() {
    return "linking (functions and variables), reconstructing return values";
  }

  @Override
  public boolean process(Application app) {
    FunctionLinker.link(app);
    FuncReturnAppend.process(app.getFunctions()); // this needs to be here to add return values of library functions, but
                                                  // why exactly?
    
    upcompiler.phase(new VariableLinker(upcompiler, true, false), app);
    
    UnlinkedPhiDeleter.process(app);// remove unused phi functions

    // process (find and append) return values of function
    ReturnValueInserter.process(app);
    FuncReturnAppend.process(app.getFunctions());
    upcompiler.phase(new VariableLinker(upcompiler, false, true), app);
    return true;
  }
  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }


}
