/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;
import cfg.function.library.stdio.PrintfReplacer;
import cfg.function.library.stdio.ScanfReplacer;

public class IoFunctionReplacer extends Phase {

  public IoFunctionReplacer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "generate code for known io functions";
  }

  @Override
  public boolean process(Application app) {
    PrintfReplacer.process(app);
    ScanfReplacer.process(app);
    upcompiler.phase(new MathReduction(upcompiler), app); // TODO why?
    upcompiler.phase(new VariableLinker(upcompiler, true, false), app);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
