/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.MathExprReduction;
import cfg.Application;

public class MathReduction extends Phase {

  public MathReduction(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "Simplifying mathematical expressions";
  }

  @Override
  public boolean process(Application app) {
    MathExprReduction.reduceMath(app.getFunctions());
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
