/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;
import cfg.function.library.FuncReplacer;

public class MemoryFuncReplacer extends Phase {

  public MemoryFuncReplacer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "replacing known memory functions like malloc and free";
  }

  @Override
  public boolean process(Application app) {
    FuncReplacer.process(app);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
