/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import graph.DominanceFrontier;
import graph.Dominator;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.PrgFunction;
import cfg.linker.InterBbVariableLinker;
import cfg.linker.IntraBbVariableLinker;
import cfg.linker.PhiInserter;

public class VariableLinker extends Phase {
  private boolean linkUnlinked;
  private boolean linkKilled;

  public VariableLinker(Upcompiler upcompiler, boolean linkUnlinked, boolean linkKilled) {
    super(upcompiler);
    this.linkUnlinked = linkUnlinked;
    this.linkKilled = linkKilled;
  }

  @Override
  public String getDescription() {
    return "linking variables, inserting phi functions whenever needed";
  }

  @Override
  public boolean process(Application app) {
    for (PrgFunction func : app.getFunctions()) {
      Dominator<BasicBlock, BbEdge> dom = new Dominator<BasicBlock, BbEdge>(func.getGraph());
      dom.calc();
      DominanceFrontier<BasicBlock, BbEdge> df = new DominanceFrontier<BasicBlock, BbEdge>(func.getGraph(),
          dom.getDom());
      df.calc();

      PhiInserter phi = new PhiInserter(func, df);
      phi.doWork();

      IntraBbVariableLinker intra = new IntraBbVariableLinker(app.getKb(), linkUnlinked, linkKilled);
      intra.visit(func, null);

      InterBbVariableLinker.link(intra, dom.getDom(), func, linkUnlinked, linkKilled);
    }
    return true;
  }
  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }


}
