/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package reduction;


import java.util.List;

import knowledge.KnowDynamicArrayAccess;
import knowledge.KnowledgeBase;
import cfg.Application;
import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.expression.VariableRefUnlinked;
import cfg.statement.AssignmentStmt;
import cfg.unlinker.HllVariable;
import cfg.variable.ArrayAccess;
import cfg.variable.SsaVariable;

public class ArrayVarReplacer extends IrReplaceExprTraverser<Void> {
  private String                 varPrefix;
  private KnowDynamicArrayAccess kdaa;

  static public void process(Application app, String varPrefix) {
    ArrayVarReplacer replacer = new ArrayVarReplacer(varPrefix, app.getKb());
    replacer.visitCollection(app.getFunctions(), null);

  }

  public ArrayVarReplacer(String varPrefix, KnowledgeBase kb) {
    this.varPrefix = varPrefix;
    kdaa = (KnowDynamicArrayAccess) kb.getEntry(KnowDynamicArrayAccess.class);
  }

  @Override
  protected void visitAssignmentStmt(AssignmentStmt obj, Void param) {
    super.visitAssignmentStmt(obj, null);
    List<Assignable> lhs = obj.getDestination();
    for (int i = 0; i < lhs.size(); i++) {
      if (lhs.get(i) instanceof ArrayAccess) {
        ArrayAccess arr = (ArrayAccess) lhs.get(i);
        if (!kdaa.hasDynamicAccess(arr.getBase())) {
          assert (arr.getIndex().getIrType() == IrType.IntConstant);
          HllVariable name = createVarName(arr);
          lhs.set(i, new SsaVariable(name, 0));
        }
      }
    }
  }

  private HllVariable createVarName(ArrayAccess arr) {
    String name = varPrefix + "_" + arr.getBase().getName().toString() + "_"
        + ((IntConstant) arr.getIndex()).getValue();
    return new HllVariable(name);
  }

  @Override
  protected Expression visitVariableArray(ArrayAccess obj, Void param) {
    if (!kdaa.hasDynamicAccess(obj.getBase())) {
      assert (obj.getIndex().getIrType() == IrType.IntConstant);
      HllVariable name = createVarName(obj);
      return new VariableRefUnlinked(name);
    } else {
      return super.visitVariableArray(obj, param);
    }
  }

}
