/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package reduction;


import java.util.HashSet;
import java.util.Set;

import knowledge.KnowReferencees;
import knowledge.KnowledgeBase;
import cfg.Assignable;
import cfg.IrStmtTraverser;
import cfg.IrType;
import cfg.function.PrgFunction;
import cfg.statement.AssignmentStmt;
import cfg.variable.Variable;

public class UnusedVariableRemover extends IrStmtTraverser<Void, Void> {
  private KnowReferencees referencees;

  public static void process(PrgFunction pfunc, KnowledgeBase base) {
    UnusedVariableRemover remover = new UnusedVariableRemover(base);
    remover.visit(pfunc, null);
  }

  public UnusedVariableRemover(KnowledgeBase kb) {
    super();
    this.referencees = (KnowReferencees) kb.getEntry(KnowReferencees.class);
  }

  @Override
  protected Void visitAssignmentStmt(AssignmentStmt obj, Void param) {
    assert( !obj.isDeleted() );
    Set<Assignable> dead = new HashSet<Assignable>();
    for (Assignable itm : obj.getDestination()) {
      if (itm.getIrType() == IrType.Variable) {
        if (referencees.getReferencees((Variable) itm).isEmpty()) {
          dead.add(itm);
        }
      }
    }
    obj.getDestination().removeAll(dead);
    return null;
  }

}
