/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package structuring;

import graph.algorithm.FindEntry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ast.expression.BooleanConstant;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CaseStmt;
import ast.statement.NullStmt;
import ast.statement.Statement;
import ast.statement.WhileStmt;
import ast.variable.VariableRefUnlinked;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.FunctionGraph;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;

public class Fallback {
  static final String switchvar = "_next";

  public static void fallback(FunctionGraph graph, Map<BasicBlock, Statement> mapping) {

    HashMap<Integer, Statement> option = new HashMap<Integer, Statement>();
    HashMap<Long, Integer> bbs = new HashMap<Long, Integer>();
    {

      ArrayList<Long> bbid = new ArrayList<Long>(graph.vertexSet().size());
      for (BasicBlock bb : graph.vertexSet()) {
        bbid.add(bb.getId());
      }
      Collections.sort(bbid);

      for (int i = 0; i < bbid.size(); i++) {
        BasicBlock bb = graph.getVertex(bbid.get(i));
        bbs.put(bb.getId(), i);
      }

      for (int i = 0; i < bbid.size(); i++) {
        BlockStmt opt = new BlockStmt();
        option.put(i, opt);
        BasicBlock bb = graph.getVertex(bbid.get(i));
        opt.addCode(mapping.get(bb));
        {
          cfg.statement.Statement last = bb.getCode().getLast();
          if (last instanceof JumpStmt) {
            Statement stmt = convertJmpToExpr((JumpStmt) last, bbs);
            opt.addCode(stmt);
          }

        }
      }
    }

    BlockStmt body = new BlockStmt();
    {
      BasicBlock entry = FindEntry.getEntry(graph);
      AssignmentStmt init = new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(bbs.get(entry
          .getId())));
      body.addCode(init);
    }
    {
      CaseStmt casestmt = new CaseStmt(new VariableRefUnlinked(switchvar), option, new NullStmt());
      WhileStmt loop = new WhileStmt(new BooleanConstant(true), casestmt);
      body.addCode(loop);
    }
    // --------------------------------------------------------------------------------------------
    Set<BasicBlock> mv = graph.vertexSet();
    Set<BbEdge> me = graph.edgeSet();
    List<cfg.statement.Statement> code = new ArrayList<cfg.statement.Statement>();
    code.add(new NopStmt());
    BasicBlock newv = new BasicBlock(0);
    newv.setCode(code);
    Merger merger = new Merger(graph);
    merger.merge(mv, me, newv);
    mapping.put(newv, body);
  }

  private static Statement convertJmpToExpr(JumpStmt last, HashMap<Long, Integer> bbs) {
    switch (last.getJmpDst().size()) {
      case 0: {
        throw new RuntimeException("Jump needs at least one output");
      }
      case 1: {
        return new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(bbs.get(last.getJmpDst().get(0))));
      }
      case 2: {
        int thenValue = bbs.get(last.getJmpDst().get(1));
        int elseValue = bbs.get(last.getJmpDst().get(0));
        IfExpr expr = new IfExpr(Translator.translate(last.getExpression()), new IntConstant(thenValue),
            new IntConstant(elseValue));
        return new AssignmentStmt(new VariableRefUnlinked(switchvar), expr);
      }
      default: {
        HashMap<Integer, Statement> option = new HashMap<Integer, Statement>(last.getJmpDst().size());
        for (int i = 0; i < last.getJmpDst().size(); i++) {
          int dstValue = bbs.get(last.getJmpDst().get(i));
          AssignmentStmt ass = new AssignmentStmt(new VariableRefUnlinked(switchvar), new IntConstant(dstValue));
          option.put(i, ass);
        }
        return new CaseStmt(Translator.translate(last.getExpression()), option, new NullStmt());
      }
    }
  }

}
