/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package structuring.matcher;


import java.util.ArrayList;
import java.util.Map;

import ast.statement.Statement;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;

public interface Pattern {
  public boolean match(BasicBlock v);

  public int internalVertices();

  public int internalEdges();

  public ArrayList<ArrayList<BasicBlock>> vertices();

  public ArrayList<ArrayList<BbEdge>> edges();

  public Statement getStmtCode(ArrayList<BasicBlock> config, Map<BasicBlock, Statement> mapping);

  public cfg.statement.Statement getNewJump(ArrayList<BasicBlock> config);
}
