/*
mnemonics.h

diStorm3 - Powerful disassembler for X86/AMD64
http://ragestorm.net/distorm/
distorm at gmail dot com
Copyright (C) 2011  Gil Dabah

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#ifndef MNEMONICS_H
#define MNEMONICS_H

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct WMnemonic {
	unsigned char length;
	unsigned char p[1]; /* p is a null terminated string, which contains 'length' characters. */
} _WMnemonic;

typedef struct WRegister {
	unsigned int length;
	unsigned char p[6]; /* p is a null terminated string. */
} _WRegister;

extern const unsigned char _MNEMONICS[];
extern const _WRegister _REGISTERS[];

#ifdef __cplusplus
} /* End Of Extern */
#endif

#define GET_REGISTER_NAME(r) (unsigned char*)_REGISTERS[(r)].p
#define GET_MNEMONIC_NAME(m) ((_WMnemonic*)&_MNEMONICS[(m)])->p

typedef enum {
	I_UNDEFINED = 0, I_AAA = 66, I_AAD = 389, I_AAM = 384, I_AAS = 76, I_ADC = 31, I_ADD = 11, I_ADDPD = 3107,
	I_ADDPS = 3100, I_ADDSD = 3121, I_ADDSS = 3114, I_ADDSUBPD = 5074, I_ADDSUBPS = 5084,
	I_AESDEC = 7882, I_AESDECLAST = 7899, I_AESENC = 7840, I_AESENCLAST = 7857,
	I_AESIMC = 7823, I_AESKEYGENASSIST = 8459, I_AND = 41, I_ANDNPD = 3018, I_ANDNPS = 3010,
	I_ANDPD = 2987, I_ANDPS = 2980, I_ARPL = 111, I_BLENDPD = 8045, I_BLENDPS = 8026,
	I_BLENDVPD = 6301, I_BLENDVPS = 6291, I_BOUND = 104, I_BSF = 939, I_BSR = 4298,
	I_BSWAP = 965, I_BT = 872, I_BTC = 934, I_BTR = 912, I_BTS = 887, I_CALL = 456,
	I_CALL_FAR = 260, I_CBW = 228, I_CDQ = 250, I_CDQE = 239, I_CLC = 492, I_CLD = 512,
	I_CLFLUSH = 4281, I_CLGI = 1830, I_CLI = 502, I_CLTS = 541, I_CMC = 487, I_CMOVA = 694,
	I_CMOVAE = 663, I_CMOVB = 656, I_CMOVBE = 686, I_CMOVG = 754, I_CMOVGE = 738,
	I_CMOVL = 731, I_CMOVLE = 746, I_CMOVNO = 648, I_CMOVNP = 723, I_CMOVNS = 708,
	I_CMOVNZ = 678, I_CMOVO = 641, I_CMOVP = 716, I_CMOVS = 701, I_CMOVZ = 671,
	I_CMP = 71, I_CMPEQPD = 4389, I_CMPEQPS = 4310, I_CMPEQSD = 4547, I_CMPEQSS = 4468,
	I_CMPLEPD = 4407, I_CMPLEPS = 4328, I_CMPLESD = 4565, I_CMPLESS = 4486, I_CMPLTPD = 4398,
	I_CMPLTPS = 4319, I_CMPLTSD = 4556, I_CMPLTSS = 4477, I_CMPNEQPD = 4428, I_CMPNEQPS = 4349,
	I_CMPNEQSD = 4586, I_CMPNEQSS = 4507, I_CMPNLEPD = 4448, I_CMPNLEPS = 4369,
	I_CMPNLESD = 4606, I_CMPNLESS = 4527, I_CMPNLTPD = 4438, I_CMPNLTPS = 4359,
	I_CMPNLTSD = 4596, I_CMPNLTSS = 4517, I_CMPORDPD = 4458, I_CMPORDPS = 4379,
	I_CMPORDSD = 4616, I_CMPORDSS = 4537, I_CMPS = 301, I_CMPUNORDPD = 4416, I_CMPUNORDPS = 4337,
	I_CMPUNORDSD = 4574, I_CMPUNORDSS = 4495, I_CMPXCHG = 898, I_CMPXCHG16B = 5053,
	I_CMPXCHG8B = 5042, I_COMISD = 2776, I_COMISS = 2768, I_CPUID = 865, I_CQO = 255,
	I_CRC32 = 7931, I_CVTDQ2PD = 5467, I_CVTDQ2PS = 3304, I_CVTPD2DQ = 5477, I_CVTPD2PI = 2678,
	I_CVTPD2PS = 3230, I_CVTPI2PD = 2492, I_CVTPI2PS = 2482, I_CVTPS2DQ = 3314,
	I_CVTPS2PD = 3220, I_CVTPS2PI = 2668, I_CVTSD2SI = 2698, I_CVTSD2SS = 3250,
	I_CVTSI2SD = 2512, I_CVTSI2SS = 2502, I_CVTSS2SD = 3240, I_CVTSS2SI = 2688,
	I_CVTTPD2DQ = 5456, I_CVTTPD2PI = 2611, I_CVTTPS2DQ = 3324, I_CVTTPS2PI = 2600,
	I_CVTTSD2SI = 2633, I_CVTTSS2SI = 2622, I_CWD = 245, I_CWDE = 233, I_DAA = 46,
	I_DAS = 56, I_DEC = 86, I_DIV = 1635, I_DIVPD = 3496, I_DIVPS = 3489, I_DIVSD = 3510,
	I_DIVSS = 3503, I_DPPD = 8280, I_DPPS = 8267, I_EMMS = 4097, I_ENTER = 340,
	I_EXTRACTPS = 8145, I_EXTRQ = 4133, I_F2XM1 = 1181, I_FABS = 1112, I_FADD = 1012,
	I_FADDP = 1538, I_FBLD = 1590, I_FBSTP = 1596, I_FCHS = 1106, I_FCLEX = 5969,
	I_FCMOVB = 1365, I_FCMOVBE = 1381, I_FCMOVE = 1373, I_FCMOVNB = 1434, I_FCMOVNBE = 1452,
	I_FCMOVNE = 1443, I_FCMOVNU = 1462, I_FCMOVU = 1390, I_FCOM = 1024, I_FCOMI = 1501,
	I_FCOMIP = 1612, I_FCOMP = 1030, I_FCOMPP = 1552, I_FCOS = 1300, I_FDECSTP = 1227,
	I_FDIV = 1050, I_FDIVP = 1583, I_FDIVR = 1056, I_FDIVRP = 1575, I_FEDISI = 1477,
	I_FEMMS = 574, I_FENI = 1471, I_FFREE = 1516, I_FIADD = 1306, I_FICOM = 1320,
	I_FICOMP = 1327, I_FIDIV = 1350, I_FIDIVR = 1357, I_FILD = 1407, I_FIMUL = 1313,
	I_FINCSTP = 1236, I_FINIT = 5984, I_FIST = 1421, I_FISTP = 1427, I_FISTTP = 1413,
	I_FISUB = 1335, I_FISUBR = 1342, I_FLD = 1063, I_FLD1 = 1130, I_FLDCW = 1087,
	I_FLDENV = 1079, I_FLDL2E = 1144, I_FLDL2T = 1136, I_FLDLG2 = 1159, I_FLDLN2 = 1167,
	I_FLDPI = 1152, I_FLDZ = 1175, I_FMUL = 1018, I_FMULP = 1545, I_FNCLEX = 5961,
	I_FNINIT = 5976, I_FNOP = 1100, I_FNSAVE = 5991, I_FNSTCW = 5946, I_FNSTENV = 5929,
	I_FNSTSW = 6006, I_FPATAN = 1202, I_FPREM = 1245, I_FPREM1 = 1219, I_FPTAN = 1195,
	I_FRNDINT = 1277, I_FRSTOR = 1508, I_FSAVE = 5999, I_FSCALE = 1286, I_FSETPM = 1485,
	I_FSIN = 1294, I_FSINCOS = 1268, I_FSQRT = 1261, I_FST = 1068, I_FSTCW = 5954,
	I_FSTENV = 5938, I_FSTP = 1073, I_FSTSW = 6014, I_FSUB = 1037, I_FSUBP = 1568,
	I_FSUBR = 1043, I_FSUBRP = 1560, I_FTST = 1118, I_FUCOM = 1523, I_FUCOMI = 1493,
	I_FUCOMIP = 1603, I_FUCOMP = 1530, I_FUCOMPP = 1398, I_FXAM = 1124, I_FXCH = 1094,
	I_FXRSTOR = 4234, I_FXSAVE = 4226, I_FXTRACT = 1210, I_FYL2X = 1188, I_FYL2XP1 = 1252,
	I_GETSEC = 633, I_HADDPD = 4158, I_HADDPS = 4166, I_HLT = 482, I_HSUBPD = 4192,
	I_HSUBPS = 4200, I_IDIV = 1640, I_IMUL = 117, I_IN = 447, I_INC = 81, I_INS = 123,
	I_INSERTPS = 8212, I_INSERTQ = 4140, I_INT = 367, I_INT_3 = 360, I_INT1 = 476,
	I_INTO = 372, I_INVD = 555, I_INVEPT = 6966, I_INVLPG = 1716, I_INVLPGA = 1844,
	I_INVVPID = 6974, I_IRET = 378, I_JA = 166, I_JAE = 147, I_JB = 143, I_JBE = 161,
	I_JCXZ = 427, I_JECXZ = 433, I_JG = 202, I_JGE = 192, I_JL = 188, I_JLE = 197,
	I_JMP = 462, I_JMP_FAR = 467, I_JNO = 138, I_JNP = 183, I_JNS = 174, I_JNZ = 156,
	I_JO = 134, I_JP = 179, I_JRCXZ = 440, I_JS = 170, I_JZ = 152, I_LAHF = 289,
	I_LAR = 522, I_LDDQU = 5674, I_LDMXCSR = 8528, I_LDS = 335, I_LEA = 223, I_LEAVE = 347,
	I_LES = 330, I_LFENCE = 4249, I_LFS = 917, I_LGDT = 1692, I_LGS = 922, I_LIDT = 1698,
	I_LLDT = 1657, I_LMSW = 1710, I_LODS = 313, I_LOOP = 421, I_LOOPNZ = 406, I_LOOPZ = 414,
	I_LSL = 527, I_LSS = 907, I_LTR = 1663, I_LZCNT = 4303, I_MASKMOVDQU = 5799,
	I_MASKMOVQ = 5789, I_MAXPD = 3556, I_MAXPS = 3549, I_MAXSD = 3570, I_MAXSS = 3563,
	I_MFENCE = 4265, I_MINPD = 3436, I_MINPS = 3429, I_MINSD = 3450, I_MINSS = 3443,
	I_MONITOR = 1760, I_MOV = 218, I_MOVAPD = 2456, I_MOVAPS = 2448, I_MOVBE = 7924,
	I_MOVD = 3917, I_MOVDDUP = 2183, I_MOVDQ2Q = 5202, I_MOVDQA = 3943, I_MOVDQU = 3951,
	I_MOVHLPS = 2148, I_MOVHPD = 2342, I_MOVHPS = 2334, I_MOVLHPS = 2325, I_MOVLPD = 2165,
	I_MOVLPS = 2157, I_MOVMSKPD = 2812, I_MOVMSKPS = 2802, I_MOVNTDQ = 5529, I_MOVNTDQA = 6577,
	I_MOVNTI = 957, I_MOVNTPD = 2553, I_MOVNTPS = 2544, I_MOVNTQ = 5521, I_MOVNTSD = 2571,
	I_MOVNTSS = 2562, I_MOVQ = 3923, I_MOVQ2DQ = 5193, I_MOVS = 295, I_MOVSD = 2107,
	I_MOVSHDUP = 2350, I_MOVSLDUP = 2173, I_MOVSS = 2100, I_MOVSX = 944, I_MOVSXD = 8597,
	I_MOVUPD = 2092, I_MOVUPS = 2084, I_MOVZX = 927, I_MPSADBW = 8293, I_MUL = 1630,
	I_MULPD = 3167, I_MULPS = 3160, I_MULSD = 3181, I_MULSS = 3174, I_MWAIT = 1769,
	I_NEG = 1625, I_NOP = 581, I_NOT = 1620, I_OR = 27, I_ORPD = 3050, I_ORPS = 3044,
	I_OUT = 451, I_OUTS = 128, I_PABSB = 6370, I_PABSD = 6400, I_PABSW = 6385,
	I_PACKSSDW = 3846, I_PACKSSWB = 3678, I_PACKUSDW = 6598, I_PACKUSWB = 3756,
	I_PADDB = 5884, I_PADDD = 5914, I_PADDQ = 5161, I_PADDSB = 5610, I_PADDSW = 5627,
	I_PADDUSB = 5300, I_PADDUSW = 5319, I_PADDW = 5899, I_PALIGNR = 8084, I_PAND = 5287,
	I_PANDN = 5345, I_PAUSE = 8605, I_PAVGB = 5360, I_PAVGUSB = 2075, I_PAVGW = 5405,
	I_PBLENDVB = 6281, I_PBLENDW = 8064, I_PCLMULQDQ = 8312, I_PCMPEQB = 4040,
	I_PCMPEQD = 4078, I_PCMPEQQ = 6558, I_PCMPEQW = 4059, I_PCMPESTRI = 8391,
	I_PCMPESTRM = 8368, I_PCMPGTB = 3699, I_PCMPGTD = 3737, I_PCMPGTQ = 6769,
	I_PCMPGTW = 3718, I_PCMPISTRI = 8436, I_PCMPISTRM = 8413, I_PEXTRB = 8103,
	I_PEXTRD = 8120, I_PEXTRQ = 8128, I_PEXTRW = 4991, I_PF2ID = 1911, I_PF2IW = 1904,
	I_PFACC = 2025, I_PFADD = 1974, I_PFCMPEQ = 2032, I_PFCMPGE = 1935, I_PFCMPGT = 1981,
	I_PFMAX = 1990, I_PFMIN = 1944, I_PFMUL = 2041, I_PFNACC = 1918, I_PFPNACC = 1926,
	I_PFRCP = 1951, I_PFRCPIT1 = 1997, I_PFRCPIT2 = 2048, I_PFRSQIT1 = 2007, I_PFRSQRT = 1958,
	I_PFSUB = 1967, I_PFSUBR = 2017, I_PHADDD = 6055, I_PHADDSW = 6072, I_PHADDW = 6038,
	I_PHMINPOSUW = 6941, I_PHSUBD = 6131, I_PHSUBSW = 6148, I_PHSUBW = 6114, I_PI2FD = 1897,
	I_PI2FW = 1890, I_PINSRB = 8195, I_PINSRD = 8233, I_PINSRQ = 8241, I_PINSRW = 4974,
	I_PMADDUBSW = 6091, I_PMADDWD = 5753, I_PMAXSB = 6856, I_PMAXSD = 6873, I_PMAXSW = 5644,
	I_PMAXUB = 5328, I_PMAXUD = 6907, I_PMAXUW = 6890, I_PMINSB = 6788, I_PMINSD = 6805,
	I_PMINSW = 5582, I_PMINUB = 5270, I_PMINUD = 6839, I_PMINUW = 6822, I_PMOVMSKB = 5211,
	I_PMOVSXBD = 6436, I_PMOVSXBQ = 6457, I_PMOVSXBW = 6415, I_PMOVSXDQ = 6520,
	I_PMOVSXWD = 6478, I_PMOVSXWQ = 6499, I_PMOVZXBD = 6664, I_PMOVZXBQ = 6685,
	I_PMOVZXBW = 6643, I_PMOVZXDQ = 6748, I_PMOVZXWD = 6706, I_PMOVZXWQ = 6727,
	I_PMULDQ = 6541, I_PMULHRSW = 6218, I_PMULHRW = 2058, I_PMULHUW = 5420, I_PMULHW = 5439,
	I_PMULLD = 6924, I_PMULLW = 5176, I_PMULUDQ = 5734, I_POP = 22, I_POPA = 98,
	I_POPCNT = 4290, I_POPF = 277, I_POR = 5599, I_PREFETCH = 1869, I_PREFETCHNTA = 2399,
	I_PREFETCHT0 = 2412, I_PREFETCHT1 = 2424, I_PREFETCHT2 = 2436, I_PREFETCHW = 1879,
	I_PSADBW = 5772, I_PSHUFB = 6021, I_PSHUFD = 3985, I_PSHUFHW = 3993, I_PSHUFLW = 4002,
	I_PSHUFW = 3977, I_PSIGNB = 6167, I_PSIGND = 6201, I_PSIGNW = 6184, I_PSLLD = 5704,
	I_PSLLDQ = 8511, I_PSLLQ = 5719, I_PSLLW = 5689, I_PSRAD = 5390, I_PSRAW = 5375,
	I_PSRLD = 5131, I_PSRLDQ = 8494, I_PSRLQ = 5146, I_PSRLW = 5116, I_PSUBB = 5824,
	I_PSUBD = 5854, I_PSUBQ = 5869, I_PSUBSB = 5548, I_PSUBSW = 5565, I_PSUBUSB = 5232,
	I_PSUBUSW = 5251, I_PSUBW = 5839, I_PSWAPD = 2067, I_PTEST = 6311, I_PUNPCKHBW = 3777,
	I_PUNPCKHDQ = 3823, I_PUNPCKHQDQ = 3892, I_PUNPCKHWD = 3800, I_PUNPCKLBW = 3609,
	I_PUNPCKLDQ = 3655, I_PUNPCKLQDQ = 3867, I_PUNPCKLWD = 3632, I_PUSH = 16,
	I_PUSHA = 91, I_PUSHF = 270, I_PXOR = 5661, I_RCL = 982, I_RCPPS = 2950, I_RCPSS = 2957,
	I_RCR = 987, I_RDMSR = 600, I_RDPMC = 607, I_RDTSC = 593, I_RDTSCP = 1861,
	I_RET = 325, I_RETF = 354, I_ROL = 972, I_ROR = 977, I_ROUNDPD = 7969, I_ROUNDPS = 7950,
	I_ROUNDSD = 8007, I_ROUNDSS = 7988, I_RSM = 882, I_RSQRTPS = 2912, I_RSQRTSS = 2921,
	I_SAHF = 283, I_SAL = 1002, I_SALC = 394, I_SAR = 1007, I_SBB = 36, I_SCAS = 319,
	I_SETA = 807, I_SETAE = 780, I_SETB = 774, I_SETBE = 800, I_SETG = 859, I_SETGE = 845,
	I_SETL = 839, I_SETLE = 852, I_SETNO = 767, I_SETNP = 832, I_SETNS = 819, I_SETNZ = 793,
	I_SETO = 761, I_SETP = 826, I_SETS = 813, I_SETZ = 787, I_SFENCE = 4273, I_SGDT = 1680,
	I_SHL = 992, I_SHLD = 876, I_SHR = 997, I_SHRD = 892, I_SHUFPD = 5016, I_SHUFPS = 5008,
	I_SIDT = 1686, I_SKINIT = 1836, I_SLDT = 1646, I_SMSW = 1704, I_SQRTPD = 2852,
	I_SQRTPS = 2844, I_SQRTSD = 2868, I_SQRTSS = 2860, I_STC = 497, I_STD = 517,
	I_STGI = 1824, I_STI = 507, I_STMXCSR = 8547, I_STOS = 307, I_STR = 1652, I_SUB = 51,
	I_SUBPD = 3376, I_SUBPS = 3369, I_SUBSD = 3390, I_SUBSS = 3383, I_SWAPGS = 1853,
	I_SYSCALL = 532, I_SYSENTER = 614, I_SYSEXIT = 624, I_SYSRET = 547, I_TEST = 206,
	I_UCOMISD = 2739, I_UCOMISS = 2730, I_UD2 = 569, I_UNPCKHPD = 2293, I_UNPCKHPS = 2283,
	I_UNPCKLPD = 2251, I_UNPCKLPS = 2241, I_VADDPD = 3136, I_VADDPS = 3128, I_VADDSD = 3152,
	I_VADDSS = 3144, I_VADDSUBPD = 5094, I_VADDSUBPS = 5105, I_VAESDEC = 7890,
	I_VAESDECLAST = 7911, I_VAESENC = 7848, I_VAESENCLAST = 7869, I_VAESIMC = 7831,
	I_VAESKEYGENASSIST = 8476, I_VANDNPD = 3035, I_VANDNPS = 3026, I_VANDPD = 3002,
	I_VANDPS = 2994, I_VBLENDPD = 8054, I_VBLENDPS = 8035, I_VBLENDVPD = 8346,
	I_VBLENDVPS = 8335, I_VBROADCASTF128 = 6354, I_VBROADCASTSD = 6340, I_VBROADCASTSS = 6326,
	I_VCMPEQPD = 4713, I_VCMPEQPS = 4626, I_VCMPEQSD = 4887, I_VCMPEQSS = 4800,
	I_VCMPESTRI = 8402, I_VCMPLEPD = 4733, I_VCMPLEPS = 4646, I_VCMPLESD = 4907,
	I_VCMPLESS = 4820, I_VCMPLTPD = 4723, I_VCMPLTPS = 4636, I_VCMPLTSD = 4897,
	I_VCMPLTSS = 4810, I_VCMPNEQPD = 4756, I_VCMPNEQPS = 4669, I_VCMPNEQSD = 4930,
	I_VCMPNEQSS = 4843, I_VCMPNLEPD = 4778, I_VCMPNLEPS = 4691, I_VCMPNLESD = 4952,
	I_VCMPNLESS = 4865, I_VCMPNLTPD = 4767, I_VCMPNLTPS = 4680, I_VCMPNLTSD = 4941,
	I_VCMPNLTSS = 4854, I_VCMPORDPD = 4789, I_VCMPORDPS = 4702, I_VCMPORDSD = 4963,
	I_VCMPORDSS = 4876, I_VCMPUNORDPD = 4743, I_VCMPUNORDPS = 4656, I_VCMPUNORDSD = 4917,
	I_VCMPUNORDSS = 4830, I_VCOMISD = 2793, I_VCOMISS = 2784, I_VCVTDQ2PD = 5499,
	I_VCVTDQ2PS = 3335, I_VCVTPD2DQ = 5510, I_VCVTPD2PS = 3293, I_VCVTPS2DQ = 3346,
	I_VCVTPS2PD = 3282, I_VCVTSD2SI = 2719, I_VCVTSD2SS = 3271, I_VCVTSI2SD = 2533,
	I_VCVTSI2SS = 2522, I_VCVTSS2SD = 3260, I_VCVTSS2SI = 2708, I_VCVTTPD2DQ = 5487,
	I_VCVTTPS2DQ = 3357, I_VCVTTSD2SI = 2656, I_VCVTTSS2SI = 2644, I_VDIVPD = 3525,
	I_VDIVPS = 3517, I_VDIVSD = 3541, I_VDIVSS = 3533, I_VDPPD = 8286, I_VDPPS = 8273,
	I_VERR = 1668, I_VERW = 1674, I_VEXTRACTF128 = 8181, I_VEXTRACTPS = 8156,
	I_VFMADD132PD = 7060, I_VFMADD132PS = 7047, I_VFMADD132SD = 7086, I_VFMADD132SS = 7073,
	I_VFMADD213PD = 7340, I_VFMADD213PS = 7327, I_VFMADD213SD = 7366, I_VFMADD213SS = 7353,
	I_VFMADD231PD = 7620, I_VFMADD231PS = 7607, I_VFMADD231SD = 7646, I_VFMADD231SS = 7633,
	I_VFMADDSUB132PD = 6999, I_VFMADDSUB132PS = 6983, I_VFMADDSUB213PD = 7279,
	I_VFMADDSUB213PS = 7263, I_VFMADDSUB231PD = 7559, I_VFMADDSUB231PS = 7543,
	I_VFMSUB132PD = 7112, I_VFMSUB132PS = 7099, I_VFMSUB132SD = 7138, I_VFMSUB132SS = 7125,
	I_VFMSUB213PD = 7392, I_VFMSUB213PS = 7379, I_VFMSUB213SD = 7418, I_VFMSUB213SS = 7405,
	I_VFMSUB231PD = 7672, I_VFMSUB231PS = 7659, I_VFMSUB231SD = 7698, I_VFMSUB231SS = 7685,
	I_VFMSUBADD132PD = 7031, I_VFMSUBADD132PS = 7015, I_VFMSUBADD213PD = 7311,
	I_VFMSUBADD213PS = 7295, I_VFMSUBADD231PD = 7591, I_VFMSUBADD231PS = 7575,
	I_VFNMADD132PD = 7165, I_VFNMADD132PS = 7151, I_VFNMADD132SD = 7193, I_VFNMADD132SS = 7179,
	I_VFNMADD213PD = 7445, I_VFNMADD213PS = 7431, I_VFNMADD213SD = 7473, I_VFNMADD213SS = 7459,
	I_VFNMADD231PD = 7725, I_VFNMADD231PS = 7711, I_VFNMADD231SD = 7753, I_VFNMADD231SS = 7739,
	I_VFNMSUB132PD = 7221, I_VFNMSUB132PS = 7207, I_VFNMSUB132SD = 7249, I_VFNMSUB132SS = 7235,
	I_VFNMSUB213PD = 7501, I_VFNMSUB213PS = 7487, I_VFNMSUB213SD = 7529, I_VFNMSUB213SS = 7515,
	I_VFNMSUB231PD = 7781, I_VFNMSUB231PS = 7767, I_VFNMSUB231SD = 7809, I_VFNMSUB231SS = 7795,
	I_VHADDPD = 4174, I_VHADDPS = 4183, I_VHSUBPD = 4208, I_VHSUBPS = 4217, I_VINSERTF128 = 8168,
	I_VINSERTPS = 8222, I_VLDDQU = 5681, I_VLDMXCSR = 8537, I_VMASKMOVDQU = 5811,
	I_VMASKMOVPD = 6631, I_VMASKMOVPS = 6619, I_VMAXPD = 3585, I_VMAXPS = 3577,
	I_VMAXSD = 3601, I_VMAXSS = 3593, I_VMCALL = 1724, I_VMCLEAR = 8575, I_VMINPD = 3465,
	I_VMINPS = 3457, I_VMINSD = 3481, I_VMINSS = 3473, I_VMLAUNCH = 1732, I_VMLOAD = 1808,
	I_VMMCALL = 1799, I_VMOVAPD = 2473, I_VMOVAPS = 2464, I_VMOVD = 3929, I_VMOVDDUP = 2231,
	I_VMOVDQA = 3959, I_VMOVDQU = 3968, I_VMOVHLPS = 2192, I_VMOVHPD = 2379, I_VMOVHPS = 2370,
	I_VMOVLHPS = 2360, I_VMOVLPD = 2211, I_VMOVLPS = 2202, I_VMOVMSKPD = 2833,
	I_VMOVMSKPS = 2822, I_VMOVNTDQ = 5538, I_VMOVNTDQA = 6587, I_VMOVNTPD = 2590,
	I_VMOVNTPS = 2580, I_VMOVQ = 3936, I_VMOVSD = 2122, I_VMOVSHDUP = 2388, I_VMOVSLDUP = 2220,
	I_VMOVSS = 2114, I_VMOVUPD = 2139, I_VMOVUPS = 2130, I_VMPSADBW = 8302, I_VMPTRLD = 8566,
	I_VMPTRST = 5065, I_VMREAD = 4125, I_VMRESUME = 1742, I_VMRUN = 1792, I_VMSAVE = 1816,
	I_VMULPD = 3196, I_VMULPS = 3188, I_VMULSD = 3212, I_VMULSS = 3204, I_VMWRITE = 4149,
	I_VMXOFF = 1752, I_VMXON = 8584, I_VORPD = 3063, I_VORPS = 3056, I_VPABSB = 6377,
	I_VPABSD = 6407, I_VPABSW = 6392, I_VPACKSSDW = 3856, I_VPACKSSWB = 3688,
	I_VPACKUSDW = 6608, I_VPACKUSWB = 3766, I_VPADDB = 5891, I_VPADDD = 5921,
	I_VPADDQ = 5168, I_VPADDSB = 5618, I_VPADDSW = 5635, I_VPADDUSW = 5309, I_VPADDW = 5906,
	I_VPALIGNR = 8093, I_VPAND = 5293, I_VPANDN = 5352, I_VPAVGB = 5367, I_VPAVGW = 5412,
	I_VPBLENDVB = 8357, I_VPBLENDVW = 8073, I_VPCLMULQDQ = 8323, I_VPCMPEQB = 4049,
	I_VPCMPEQD = 4087, I_VPCMPEQQ = 6567, I_VPCMPEQW = 4068, I_VPCMPESTRM = 8379,
	I_VPCMPGTB = 3708, I_VPCMPGTD = 3746, I_VPCMPGTQ = 6778, I_VPCMPGTW = 3727,
	I_VPCMPISTRI = 8447, I_VPCMPISTRM = 8424, I_VPERM2F128 = 7938, I_VPERMILPD = 6250,
	I_VPERMILPS = 6239, I_VPEXTRB = 8111, I_VPEXTRD = 8136, I_VPEXTRW = 4999,
	I_VPHADDD = 6063, I_VPHADDSW = 6081, I_VPHADDW = 6046, I_VPHMINPOSUW = 6953,
	I_VPHSUBD = 6139, I_VPHSUBSW = 6157, I_VPHSUBW = 6122, I_VPINSRB = 8203, I_VPINSRD = 8249,
	I_VPINSRQ = 8258, I_VPINSRW = 4982, I_VPMADDUBSW = 6102, I_VPMADDWD = 5762,
	I_VPMAXSB = 6864, I_VPMAXSD = 6881, I_VPMAXSW = 5652, I_VPMAXUB = 5336, I_VPMAXUD = 6915,
	I_VPMAXUW = 6898, I_VPMINSB = 6796, I_VPMINSD = 6813, I_VPMINSW = 5590, I_VPMINUB = 5278,
	I_VPMINUD = 6847, I_VPMINUW = 6830, I_VPMOVMSKB = 5221, I_VPMOVSXBD = 6446,
	I_VPMOVSXBQ = 6467, I_VPMOVSXBW = 6425, I_VPMOVSXDQ = 6530, I_VPMOVSXWD = 6488,
	I_VPMOVSXWQ = 6509, I_VPMOVZXBD = 6674, I_VPMOVZXBQ = 6695, I_VPMOVZXBW = 6653,
	I_VPMOVZXDQ = 6758, I_VPMOVZXWD = 6716, I_VPMOVZXWQ = 6737, I_VPMULDQ = 6549,
	I_VPMULHRSW = 6228, I_VPMULHUW = 5429, I_VPMULHW = 5447, I_VPMULLD = 6932,
	I_VPMULLW = 5184, I_VPMULUDQ = 5743, I_VPOR = 5604, I_VPSADBW = 5780, I_VPSHUFB = 6029,
	I_VPSHUFD = 4011, I_VPSHUFHW = 4020, I_VPSHUFLW = 4030, I_VPSIGNB = 6175,
	I_VPSIGND = 6209, I_VPSIGNW = 6192, I_VPSLLD = 5711, I_VPSLLDQ = 8519, I_VPSLLQ = 5726,
	I_VPSLLW = 5696, I_VPSRAD = 5397, I_VPSRAW = 5382, I_VPSRLD = 5138, I_VPSRLDQ = 8502,
	I_VPSRLQ = 5153, I_VPSRLW = 5123, I_VPSUBB = 5831, I_VPSUBD = 5861, I_VPSUBQ = 5876,
	I_VPSUBSB = 5556, I_VPSUBSW = 5573, I_VPSUBUSB = 5241, I_VPSUBUSW = 5260,
	I_VPSUBW = 5846, I_VPTEST = 6318, I_VPTESTPD = 6271, I_VPTESTPS = 6261, I_VPUNPCKHBW = 3788,
	I_VPUNPCKHDQ = 3834, I_VPUNPCKHQDQ = 3904, I_VPUNPCKHWD = 3811, I_VPUNPCKLBW = 3620,
	I_VPUNPCKLDQ = 3666, I_VPUNPCKLQDQ = 3879, I_VPUNPCKLWD = 3643, I_VPXOR = 5667,
	I_VRCPPS = 2972, I_VRCPSS = 2964, I_VROUNDPD = 7978, I_VROUNDPS = 7959, I_VROUNDSD = 8016,
	I_VROUNDSS = 7997, I_VRSQRTPS = 2940, I_VRSQRTSS = 2930, I_VSHUFPD = 5033,
	I_VSHUFPS = 5024, I_VSQRTPD = 2903, I_VSQRTPS = 2894, I_VSQRTSD = 2885, I_VSQRTSS = 2876,
	I_VSTMXCSR = 8556, I_VSUBPD = 3405, I_VSUBPS = 3397, I_VSUBSD = 3421, I_VSUBSS = 3413,
	I_VUCOMISD = 2758, I_VUCOMISS = 2748, I_VUNPCKHPD = 2314, I_VUNPCKHPS = 2303,
	I_VUNPCKLPD = 2272, I_VUNPCKLPS = 2261, I_VXORPD = 3092, I_VXORPS = 3084,
	I_VZEROALL = 4115, I_VZEROUPPER = 4103, I_WAIT = 8591, I_WBINVD = 561, I_WRMSR = 586,
	I_XADD = 951, I_XAVE = 4243, I_XCHG = 212, I_XGETBV = 1776, I_XLAT = 400, I_XOR = 61,
	I_XORPD = 3077, I_XORPS = 3070, I_XRSTOR = 4257, I_XSETBV = 1784
} _InstructionType;

typedef enum {
	R_RAX, R_RCX, R_RDX, R_RBX, R_RSP, R_RBP, R_RSI, R_RDI, R_R8, R_R9, R_R10, R_R11, R_R12, R_R13, R_R14, R_R15,
	R_EAX, R_ECX, R_EDX, R_EBX, R_ESP, R_EBP, R_ESI, R_EDI, R_R8D, R_R9D, R_R10D, R_R11D, R_R12D, R_R13D, R_R14D, R_R15D,
	R_AX, R_CX, R_DX, R_BX, R_SP, R_BP, R_SI, R_DI, R_R8W, R_R9W, R_R10W, R_R11W, R_R12W, R_R13W, R_R14W, R_R15W,
	R_AL, R_CL, R_DL, R_BL, R_AH, R_CH, R_DH, R_BH, R_R8B, R_R9B, R_R10B, R_R11B, R_R12B, R_R13B, R_R14B, R_R15B,
	R_SPL, R_BPL, R_SIL, R_DIL,
	R_ES, R_CS, R_SS, R_DS, R_FS, R_GS,
	R_RIP,
	R_ST0, R_ST1, R_ST2, R_ST3, R_ST4, R_ST5, R_ST6, R_ST7,
	R_MM0, R_MM1, R_MM2, R_MM3, R_MM4, R_MM5, R_MM6, R_MM7,
	R_XMM0, R_XMM1, R_XMM2, R_XMM3, R_XMM4, R_XMM5, R_XMM6, R_XMM7, R_XMM8, R_XMM9, R_XMM10, R_XMM11, R_XMM12, R_XMM13, R_XMM14, R_XMM15,
	R_YMM0, R_YMM1, R_YMM2, R_YMM3, R_YMM4, R_YMM5, R_YMM6, R_YMM7, R_YMM8, R_YMM9, R_YMM10, R_YMM11, R_YMM12, R_YMM13, R_YMM14, R_YMM15,
	R_CR0, R_UNUSED0, R_CR2, R_CR3, R_CR4, R_UNUSED1, R_UNUSED2, R_UNUSED3, R_CR8,
	R_DR0, R_DR1, R_DR2, R_DR3, R_UNUSED4, R_UNUSED5, R_DR6, R_DR7
} _RegisterType;

#endif /* MNEMONICS_H */
