/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast;

import java.util.ArrayList;
import java.util.List;

import ast.expression.Expression;
import ast.statement.BlockStmt;
import ast.statement.NullStmt;
import ast.statement.Statement;
import ast.traverser.AstStatementTraverser;
import ast.traverser.AstTraverser;
import ast.variable.Variable;

public class BlockNormalizer extends AstStatementTraverser<Void> {

  static public void normalize(Ast ast) {
    AstTraverser<Void> asttraverser = new AstTraverser<Void>(new BlockNormalizer());
    asttraverser.visit(ast, null);
  }

  @Override
  public Expression visit(Expression expr, Void param) {
    return expr;
  }

  @Override
  public Variable visit(Variable expr, Void param) {
    return expr;
  }

  @Override
  protected Statement visitBlockStmt(BlockStmt obj, Void param) {
    List<Statement> out = new ArrayList<Statement>();
    for (Statement stmt : obj.getBlock()) {
      stmt = visit(stmt, null);
      if (stmt instanceof BlockStmt) {
        out.addAll(((BlockStmt) stmt).getBlock());
      } else if (!(stmt instanceof NullStmt)) {
        out.add(stmt);
      }
    }
    switch (out.size()) {
      case 0:
        return new NullStmt();
      case 1:
        return out.get(0);
      default:
        return new BlockStmt(out);
    }
  }

}
