/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast;

import java.util.ArrayList;
import java.util.List;

import ast.type.Type;
import ast.variable.Variable;

public class FuncPrototoype extends Function {
  private String              library = null;
  private String              name;
  private ArrayList<Variable> param   = new ArrayList<Variable>();
  private Type                rettype;

  public FuncPrototoype(String name, ArrayList<Variable> param, Type rettype) {
    super();
    this.name = name;
    this.param = param;
    this.rettype = rettype;
    assert (name != null);
    assert (param != null);
    assert (rettype != null);
  }

  public FuncPrototoype(String library, String name, ArrayList<Variable> param, Type rettype) {
    this.library = library;
    this.name = name;
    this.param = param;
    this.rettype = rettype;
    assert (name != null);
    assert (param != null);
    assert (rettype != null);
  }

  @Override
  public Type getReturnType() {
    return rettype;
  }

  @Override
  public List<Variable> getParam() {
    return param;
  }

  @Override
  public String getName() {
    if (library == null) {
      return name;
    } else {
      return library + "." + name;
    }
  }

}
