/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast;

import java.util.ArrayList;
import java.util.List;

import ast.type.Type;
import ast.variable.Variable;

public class LibFuncs {
  final static private String ioLibName = "IoSupport";
  
  static public final List<FuncPrototoype> func        = new ArrayList<FuncPrototoype>();

  public static final FuncPrototoype       writeInt    = new FuncPrototoype(ioLibName,"writeInt",
                                                           makeParam("value", Type.Integer), Type.Void);
  public static final FuncPrototoype       writeStr    = new FuncPrototoype(ioLibName,"writeStr", makeParam("text", Type.String),
                                                           Type.Void);
  public static final FuncPrototoype       writeNl     = new FuncPrototoype(ioLibName,"writeNl", new ArrayList<Variable>(),
                                                           Type.Void);
  public static final FuncPrototoype       readInt     = new FuncPrototoype(ioLibName,"readInt", new ArrayList<Variable>(),
                                                           Type.Integer);

  public static final FuncPrototoype       ptrNew      = new FuncPrototoype("ptrMalloc", makeParam("size", Type.Number),
                                                           Type.Pointer);
  public static final FuncPrototoype       ptrDestroy  = new FuncPrototoype("ptrFree",
                                                           makeParam("ptr", Type.Pointer), Type.Void);
  public static final FuncPrototoype       ptrCopy     = new FuncPrototoype("ptrCopy", makeParam("src", Type.Pointer,
                                                           "displacement", Type.Integer), Type.Pointer);
  public static final FuncPrototoype       ptrGetValue = new FuncPrototoype("ptrGetValue", makeParam("ptr",
                                                           Type.Pointer, "displacement", Type.Integer), Type.Generic);
  public static final FuncPrototoype       ptrSetValue = new FuncPrototoype("ptrSetValue", makeParam("ptr",
                                                           Type.Pointer, "displacement", Type.Integer, "value",
                                                           Type.Generic), Type.Void);

  private static ArrayList<Variable> makeParam(String name, Type type) {
    ArrayList<Variable> res = new ArrayList<Variable>(1);
    res.add(new Variable(name, type));
    return res;
  }

  private static ArrayList<Variable> makeParam(String name1, Type type1, String name2, Type type2) {
    ArrayList<Variable> res = new ArrayList<Variable>(1);
    res.add(new Variable(name1, type1));
    res.add(new Variable(name2, type2));
    return res;
  }

  private static ArrayList<Variable> makeParam(String name1, Type type1, String name2, Type type2, String name3,
      Type type3) {
    ArrayList<Variable> res = new ArrayList<Variable>(1);
    res.add(new Variable(name1, type1));
    res.add(new Variable(name2, type2));
    res.add(new Variable(name3, type3));
    return res;
  }

  {
    func.add(writeInt);
    func.add(writeStr);
    func.add(writeNl);
    func.add(readInt);
    func.add(ptrNew);
    func.add(ptrDestroy);
    func.add(ptrGetValue);
    func.add(ptrSetValue);
  }

}
