/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.expression;

public class CompareExpr extends Expression {

  private Expression left;
  private Expression right;
  private CompareOp  operand;

  public CompareExpr(Expression left, Expression right, CompareOp operand) {
    super();
    this.left = left;
    this.right = right;
    this.operand = operand;
  }

  public Expression getLeft() {
    return left;
  }

  public Expression getRight() {
    return right;
  }

  public CompareOp getOperand() {
    return operand;
  }

  public void setLeft(Expression left) {
    this.left = left;
  }

  public void setRight(Expression right) {
    this.right = right;
  }

  public final void setOperand(CompareOp operand) {
    this.operand = operand;
  }

  @Override
  public String toString() {
    return "(" + left + " " + operand + " " + right + ")";
  }

}
