/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.statement;

import ast.expression.Expression;

public class AssignmentStmt extends Statement {
  private Expression destination;
  private Expression source;

  public AssignmentStmt(Expression assignable, Expression source) {
    this.destination = assignable;
    this.source = source;
  }

  public Expression getDestination() {
    return destination;
  }

  public Expression getSource() {
    return source;
  }

  public void setSource(Expression source) {
    assert (source != null);
    this.source = source;
  }

  public void setDestination(Expression destination) {
    this.destination = destination;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(destination);
    sb.append(" = ");
    sb.append(source);
    return sb.toString();
  }

}
