/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.statement;

import java.util.ArrayList;
import java.util.List;

public class BlockStmt extends Statement {
  private List<Statement> block;

  public BlockStmt(List<Statement> block) {
    super();
    this.block = block;
  }

  public BlockStmt() {
    super();
    this.block = new ArrayList<Statement>();
  }

  public List<Statement> getBlock() {
    return block;
  }

  public void setBlock(List<Statement> block) {
    this.block = block;
  }

  public void addCode(Statement op) {
    assert( op != null );
    block.add(op);
  }

}
