/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.statement;

import java.util.HashMap;

import ast.expression.Expression;

public class CaseStmt extends Statement {
  private Expression                  condition;
  private HashMap<Integer, Statement> option;
  private Statement                   other;

  public CaseStmt(Expression condition, HashMap<Integer, Statement> option, Statement other) {
    super();
    this.condition = condition;
    this.option = option;
    this.other = other;
    assert( condition != null );
    assert( option != null );
    assert( other != null );
  }

  public Expression getCondition() {
    return condition;
  }

  public void setCondition(Expression condition) {
    this.condition = condition;
  }

  public HashMap<Integer, Statement> getOption() {
    return option;
  }

  public void setOption(HashMap<Integer, Statement> option) {
    this.option = option;
  }

  public Statement getOther() {
    return other;
  }

  public void setOther(Statement other) {
    this.other = other;
  }
}
