/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.statement;

import ast.expression.Expression;

public class IfStmt extends Statement {
  private Expression condition;
  private Statement  thenBranch;
  private Statement  elseBranch;

  public IfStmt(Expression condition, Statement thenBranch, Statement elseBranch) {
    super();
    this.condition = condition;
    this.thenBranch = thenBranch;
    this.elseBranch = elseBranch;
    assert( condition != null );
    assert( thenBranch != null );
    assert( elseBranch != null );
  }

  public IfStmt(Expression condition, Statement thenBranch) {
    super();
    this.condition = condition;
    this.thenBranch = thenBranch;
    this.elseBranch = new NullStmt();
    assert( condition != null );
    assert( thenBranch != null );
    assert( elseBranch != null );
  }

  public Expression getCondition() {
    return condition;
  }

  public void setCondition(Expression condition) {
    this.condition = condition;
  }

  public Statement getThenBranch() {
    return thenBranch;
  }

  public void setThenBranch(Statement thenBranch) {
    this.thenBranch = thenBranch;
  }

  public Statement getElseBranch() {
    return elseBranch;
  }

  public void setElseBranch(Statement elseBranch) {
    this.elseBranch = elseBranch;
  }

}
