/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.statement;

import ast.PrgFunc;
import ast.expression.Expression;

public class RetStmt extends Statement {

  private Expression retval;
  private PrgFunc    function;

  public RetStmt(Expression retval) {
    assert( retval != null );
    this.retval = retval;
  }

  public Expression getRetval() {
    return retval;
  }

  public void setRetval(Expression retval) {
    this.retval = retval;
  }

  public PrgFunc getFunction() {
    assert( function != null );
    return function;
  }

  public void setFunction(PrgFunc function) {
    this.function = function;
  }

  @Override
  public String toString() {
    return "return " + retval;
  }

}
