/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.List;

import ast.expression.ArithmeticExpr;
import ast.expression.BooleanConstant;
import ast.expression.CallExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.FunctionRef;
import ast.expression.FunctionRefLinked;
import ast.expression.FunctionRefUnlinked;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.expression.NullConstExpr;
import ast.expression.NullExpr;
import ast.expression.StringConstant;
import ast.expression.UnaryExpression;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.variable.ArrayAccess;
import ast.variable.Variable;
import ast.variable.VariableRef;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;

public class AstExpressionTraverser<P> {
  protected FunctionRef visit(FunctionRef obj, P param) {
    if (obj instanceof FunctionRefLinked) return visitFunctionRefLinked((FunctionRefLinked) obj, param);
    else if (obj instanceof FunctionRefUnlinked) return visitFunctionRefUnlinked((FunctionRefUnlinked) obj, param);
    else
      throw new RuntimeException("Unhandled class: " + obj.getClass());
  }

  protected FunctionRef visitFunctionRefUnlinked(FunctionRefUnlinked obj, P param) {
    return obj;
  }

  protected FunctionRef visitFunctionRefLinked(FunctionRefLinked obj, P param) {
    return obj;
  }

  public Variable visit(Variable obj, P param) {
    return obj;
  }

  final public void visit(List<Expression> obj, P param) {
    for (int i = 0; i < obj.size(); i++) {
      Expression expr = obj.get(i);
      expr = visit(expr, param);
      obj.set(i, expr);
    }
  }

  public Expression visit(Expression obj, P param) {
    if (obj instanceof CompareExpr) return visitCompareExpr((CompareExpr) obj, param);
    else if (obj instanceof ArithmeticExpr) return visitArithmeticExpr((ArithmeticExpr) obj, param);
    else if (obj instanceof IfExpr) return visitIfExpr((IfExpr) obj, param);
    else if (obj instanceof VariableRefUnlinked) return visitVariableRefUnlinked((VariableRefUnlinked) obj, param);
    else if (obj instanceof VariableRefLinked) return visitVariableRefLinked((VariableRefLinked) obj, param);
    else if (obj instanceof IntConstant) return visitConstant((IntConstant) obj, param);
    else if (obj instanceof StringConstant) return visitStringConstant((StringConstant) obj, param);
    else if (obj instanceof BooleanConstant) return visitBooleanConstant((BooleanConstant) obj, param);
    else if (obj instanceof UnaryExpression) return visitUnaryExpression((UnaryExpression) obj, param);
    else if (obj instanceof CallExpr) return visitCallExpr((CallExpr) obj, param);
    else if (obj instanceof VariablePtrDeref) return visitVariablePtrDeref((VariablePtrDeref) obj, param);
    else if (obj instanceof VariablePtrOf) return visitVariablePtrOf((VariablePtrOf) obj, param);
    else if (obj instanceof ArrayAccess) return visitArrayAccess((ArrayAccess) obj, param);
    else if (obj instanceof NullConstExpr) return visitNullConstExpr((NullConstExpr) obj, param);
    else if (obj instanceof NullExpr) return visitNullExpr((NullExpr) obj, param);
    else
      throw new RuntimeException("Unhandled class: " + obj.getClass());
  }

  protected Expression visitNullExpr(NullExpr obj, P param) {
    return obj;
  }

  protected Expression visitNullConstExpr(NullConstExpr obj, P param) {
    return obj;
  }

  protected Expression visitArrayAccess(ArrayAccess obj, P param) {
    obj.setBase((VariableRef) visit(obj.getBase(), param));
    obj.setIndex(visit(obj.getIndex(), param));
    return obj;
  }

  protected Expression visitVariablePtrOf(VariablePtrOf obj, P param) {
    obj.setVar((ArrayAccess) visit(obj.getVar(), param));
    return obj;
  }

  protected Expression visitVariablePtrDeref(VariablePtrDeref obj, P param) {
    obj.setExpr(visit(obj.getExpr(), param));
    return obj;
  }

  protected Expression visitCallExpr(CallExpr obj, P param) {
    obj.setFunction(visit(obj.getFunction(), param));
    visit(obj.getParam(), param);
    return obj;
  }

  protected Expression visitUnaryExpression(UnaryExpression obj, P param) {
    obj.setExpr(visit(obj.getExpr(), param));
    return obj;
  }

  protected Expression visitVariableRefUnlinked(VariableRefUnlinked obj, P param) {
    return obj;
  }

  protected Expression visitVariableRefLinked(VariableRefLinked obj, P param) {
    return obj;
  }

  protected Expression visitBooleanConstant(BooleanConstant obj, P param) {
    return obj;
  }

  protected Expression visitConstant(IntConstant obj, P param) {
    return obj;
  }

  protected Expression visitStringConstant(StringConstant obj, P param) {
    return obj;
  }

  protected Expression visitIfExpr(IfExpr obj, P param) {
    obj.setCondition(visit(obj.getCondition(), param));
    obj.setLeft(visit(obj.getLeft(), param));
    obj.setRight(visit(obj.getRight(), param));
    return obj;
  }

  protected Expression visitArithmeticExpr(ArithmeticExpr obj, P param) {
    obj.setLeft(visit(obj.getLeft(), param));
    obj.setRight(visit(obj.getRight(), param));
    return obj;
  }

  protected Expression visitCompareExpr(CompareExpr obj, P param) {
    obj.setLeft(visit(obj.getLeft(), param));
    obj.setRight(visit(obj.getRight(), param));
    return obj;
  }

}
