/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.Map;

import ast.Ast;
import ast.Function;
import ast.expression.FunctionRef;
import ast.expression.FunctionRefLinked;
import ast.expression.FunctionRefUnlinked;

public class FunctionLinker extends AstExpressionTraverser<Void> {
  static public void process(Ast func, Map<Long, Function> functions) {
    AstTraverser<Void> visitor = new AstTraverser<Void>(new NopAstStatementTraverser<Void>(new FunctionLinker(functions)));
    visitor.visit(func, null);
  }

  private Map<Long, Function> functions;

  public FunctionLinker(Map<Long, Function> functions) {
    super();
    this.functions = functions;
  }

  @Override
  protected FunctionRef visitFunctionRefUnlinked(FunctionRefUnlinked obj, Void param) {
    Function func = functions.get(obj.getAddr());
    if (func != null) {
      assert (func != null);
      return new FunctionRefLinked(func);
    } else {
      System.err.println( "Function reference not found for: " + obj );
      return obj;
    }
  }

}
