/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import ast.Ast;
import ast.PrgFunc;
import ast.expression.Expression;
import ast.type.Type;
import ast.variable.Variable;

public class MissingTypeCheater extends AstTraverser<Void> {
  public MissingTypeCheater() {
    super(new MissingTypeCheaterStmt());
  }

  static public void process(Ast ast) {
    MissingTypeCheater traverser = new MissingTypeCheater();
    traverser.visit(ast, null);
  }

  static Type replace(Type type) {
    switch (type) {
      case Generic:
      case Number:
      case Scalar: {
        return Type.Integer;
      }
      default:
        return type;
    }
  }

  @Override
  protected Ast visitPrgFunc(PrgFunc obj, Void param) {
    obj.setReturnType(replace(obj.getReturnType()));
    return super.visitPrgFunc(obj, null);
  }

}

class MissingTypeCheaterStmt extends AstStatementTraverser<Void> {

  @Override
  public Expression visit(Expression expr, Void param) {
    return expr;
  }

  @Override
  public Variable visit(Variable expr, Void param) {
    expr.setType(MissingTypeCheater.replace(expr.getType()));
    return expr;
  }

}
