/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

//FIXME replace pointer comparsion with .equals
import java.util.ArrayList;
import java.util.List;

import knowledge.KnowTypes;
import ast.LibFuncs;
import ast.expression.ArithmeticExpr;
import ast.expression.CallExpr;
import ast.expression.Expression;
import ast.expression.FunctionRefLinked;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.Statement;
import ast.type.Type;
import ast.variable.Variable;
import cfg.Application;

public class PointerAccessRemover extends AstTraverser<KnowTypes> {

  public PointerAccessRemover() {
    super(new PointerAccessRemoverStmt());
  }

  public static void process(Application app) {
    KnowTypes kt = (KnowTypes) app.getKb().getEntry(KnowTypes.class);
    PointerAccessRemover remover = new PointerAccessRemover();
    remover.visit(app.getPrg(), kt);
  }

}

class PointerAccessRemoverStmt extends AstStatementTraverser<KnowTypes> {
  private PointerAccessRemoverExpr exptrav = new PointerAccessRemoverExpr();

  @Override
  public Expression visit(Expression expr, KnowTypes param) {
    return exptrav.visit(expr, param);
  }

  @Override
  public Variable visit(Variable expr, KnowTypes param) {
    return exptrav.visit(expr, param);
  }

  @Override
  protected Statement visitAssignmentStmt(AssignmentStmt obj, KnowTypes param) {
    if (obj.getDestination() instanceof VariablePtrDeref) {
      Expression value = visit(obj.getSource(), param);

      List<Expression> arguments = new ArrayList<Expression>(2);
      PointerExprMatcher matcher = new PointerExprMatcher(((VariablePtrDeref) obj.getDestination()).getExpr(), param);

      arguments.add(matcher.getPointer());
      arguments.add(matcher.getDisplacement());
      arguments.add(value);

      return new CallStmt(new CallExpr(new FunctionRefLinked(LibFuncs.ptrSetValue), arguments));
    } else if ((obj.getSource() instanceof ArithmeticExpr) && (param.getTypeOf(obj.getDestination()) == Type.Pointer)) {
      List<Expression> arguments = new ArrayList<Expression>(2);
      PointerExprMatcher matcher = new PointerExprMatcher(obj.getSource(), param);

      arguments.add(matcher.getPointer());
      arguments.add(matcher.getDisplacement());

      obj.setSource(new CallExpr(new FunctionRefLinked(LibFuncs.ptrCopy), arguments));

      return obj;
    } else {
      return super.visitAssignmentStmt(obj, param);
    }
  }

}

class PointerAccessRemoverExpr extends AstExpressionTraverser<KnowTypes> {

  // reading from pointer location
  @Override
  protected Expression visitVariablePtrDeref(VariablePtrDeref obj, KnowTypes param) {
    List<Expression> arguments = new ArrayList<Expression>(2);
    PointerExprMatcher matcher = new PointerExprMatcher(obj.getExpr(), param);

    arguments.add(matcher.getPointer());
    arguments.add(matcher.getDisplacement());

    return new CallExpr(new FunctionRefLinked(LibFuncs.ptrGetValue), arguments);
  }

  @Override
  protected Expression visitVariablePtrOf(VariablePtrOf obj, KnowTypes param) {
    List<Expression> arguments = new ArrayList<Expression>(2);
    PointerExprMatcher matcher = new PointerExprMatcher(obj, param);

    arguments.add(matcher.getPointer());
    arguments.add(matcher.getDisplacement());

    return new CallExpr(new FunctionRefLinked(LibFuncs.ptrCopy), arguments);
  }

}
