/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import knowledge.KnowTypes;
import ast.expression.Expression;
import ast.expression.IntConstant;
import ast.expression.NullConstExpr;
import ast.type.Type;
import cfg.Application;

// replaces int constant (with value 0) with null
public class PointerNullConstReplacer extends AstTraverser<Void> {

  public static void process(Application app) {
    KnowTypes kt = (KnowTypes) app.getKb().getEntry(KnowTypes.class);
    PointerNullConstReplacer constReplacer = new PointerNullConstReplacer(kt);
    constReplacer.visit(app.getPrg(), null);
  }

  public PointerNullConstReplacer(KnowTypes kt) {
    super(new NopAstStatementTraverser<Void>(new ExprPointerNullConstReplacer(kt)));
  }
}

class ExprPointerNullConstReplacer extends AstExpressionTraverser<Void> {
  KnowTypes kt;

  public ExprPointerNullConstReplacer(KnowTypes kt) {
    super();
    this.kt = kt;
  }

  @Override
  protected Expression visitConstant(IntConstant obj, Void param) {
    Type type = kt.getTypeOf(obj);
    if (type == Type.Pointer) {
      if (obj.getValue() != 0) {
        throw new RuntimeException("Can not handle pointer constant different than 0 (is " + obj.getValue() + ")");
      } else {
        return new NullConstExpr();
      }
    } else {
      return obj;
    }
  }

}
