/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import ast.Program;
import ast.expression.Expression;
import ast.variable.Variable;

public class VariableNameRemover extends AstStatementTraverser<Void> {

  @Override
  public Expression visit(Expression expr, Void param) {
    return expr;
  }

  @Override
  public Variable visit(Variable expr, Void param) {
    expr.setName(null);
    return expr;
  }

  public static void process(Program prg) {
    AstTraverser<Void> traverser = new AstTraverser<Void>( new VariableNameRemover() );
    traverser.visit(prg, null);
  }

}
