/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IrItr implements Iterator<IrElement>, Iterable<IrElement> {
  private LinkedList<IrElement> path = new LinkedList<IrElement>();

  public IrItr( IrElement root ) {
    super();
    path.push(root);
  }

  public boolean hasNext() {
    return !path.isEmpty();
  }

  public IrElement next() {
    assert (hasNext());

    // inorder IR-tree iterator
    IrElement nextElem = path.peek();
    
    List<? extends IrElement> children = nextElem.getChildren();
    if (!children.isEmpty()) {          // go down
      path.push(children.get(0));
    } else {                            // go up
      while (true) {
        IrElement act = path.pop();
        if( path.isEmpty() ){
          break;
        }
        IrElement parent = path.peek();
        List<? extends IrElement> silblings = parent.getChildren();
        int next = 1 + silblings.indexOf(act);
        if (next < silblings.size()) {
          path.push( silblings.get(next) );
          break;
        }
      }
    }
    return nextElem;
  }

  public IrElement peek() {
    return path.peek();
  }
  
  public void remove() {
    throw new RuntimeException( "Not yet implemented" );
  }

  public Iterator<IrElement> iterator() {
    return this;
  }

}
