/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;

import cfg.expression.Expression;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;

/**
 * Traverses not deeper as statements
 */
public class IrStmtTraverser<R, P> extends IrTraverser<R, P> {

  @Override
  protected R visitExpression(Expression obj, P param) {
    return null;
  }

  @Override
  protected R visitJumpStmt(JumpStmt obj, P param) {
    return null;
  }

  @Override
  protected R visitNopStmt(NopStmt obj, P param) {
    return null;
  }

  @Override
  protected R visitAssignmentStmt(AssignmentStmt obj, P param) {
    return null;
  }

}
