/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;


import java.util.List;

import cfg.expression.Expression;

public class StringConstant implements Expression {

  private String content;

  public StringConstant(String content) {
    this.content = content;
  }

  public String getContent() {
    return content;
  }

  @Override
  public String toString() {
    return "\"" + content + "\"";
  }

  public IrType getIrType() {
    throw new RuntimeException("Not yet implemented");
  }

  public List<? extends IrElement> getChildren() {
    throw new RuntimeException("Not yet implemented");
  }

}
