/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;

import cfg.IrType;
import cfg.function.Function;

public class CallExprLinked extends CallExpr {
  private Function func;

  public CallExprLinked(Function func) {
    super();
    this.func = func;
  }

  public Function getFunc() {
    return func;
  }

  @Override
  public String toString() {
    return "call " + func.toString() + super.toString();
  }

  public IrType getIrType() {
    return IrType.CallExprLinked;
  }
}
