/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.ArrayList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;

public class IfExpr implements BinaryExpr, Expression {
  private Expression condition;
  private Expression left;
  private Expression right;

  public IfExpr(Expression condition, Expression left, Expression right) {
    super();
    this.condition = condition;
    this.left = left;
    this.right = right;
  }

  public Expression getCondition() {
    return condition;
  }

  public void setCondition(Expression expr) {
    condition = expr;
  }

  public Expression getLeft() {
    return left;
  }

  public Expression getRight() {
    return right;
  }

  public void setLeft(Expression left) {
    this.left = left;
  }

  public void setRight(Expression right) {
    this.right = right;
  }

  @Override
  public String toString() {
    return condition + " ? " + left + " : " + right;
  }

  public IrType getIrType() {
    return IrType.IfExpr; // FIXME change to builtin function
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>(3);
    res.add(condition);
    res.add(left);
    res.add(right);
    return res;
  }
}
