/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.ArrayList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;

public class IntegerExpr implements BinaryExpr {
  private Expression left;
  private Expression right;
  private IntegerOp  op;

  public IntegerExpr(Expression left, Expression right, IntegerOp op) {
    super();
    this.left = left;
    this.right = right;
    this.op = op;
  }

  public Expression getLeft() {
    return left;
  }

  public Expression getRight() {
    return right;
  }

  public IntegerOp getOp() {
    return op;
  }

  public void setLeft(Expression left) {
    this.left = left;
  }

  public void setRight(Expression right) {
    this.right = right;
  }

  @Override
  public String toString() {
    return "(" + left + " " + op + " " + right + ")";
  }

  public IrType getIrType() {
    return IrType.IntegerExpr;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>(2);
    res.add(left);
    res.add(right);
    return res;
  }
}
