/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.LinkedList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.function.Function;
import cfg.variable.VariableName;

public class VariableKilled implements Expression, VariableRef {
  private VariableName name;
  private Function     killer;

  public VariableKilled(VariableName name, Function killer) {
    super();
    this.name = name;
    this.killer = killer;
  }

  public VariableName getName() {
    return name;
  }

  public Function getKiller() {
    return killer;
  }

  @Override
  public String toString() {
    return "`" + name + "`(" + killer + ")";
  }

  public IrType getIrType() {
    return IrType.VariableRefKilled;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
