/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.LinkedList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.variable.Variable;
import cfg.variable.VariableName;

public class VariableRefLinked implements Expression, VariableRef {
  private Variable reference = null;

  public VariableRefLinked(Variable var) {
    super();
    this.reference = var;
  }

  public VariableName getName() {
    return reference.getName();
  }

  public Variable getReference() {
    return reference;
  }

  @Override
  public String toString() {
    return reference.toString();
  }

  public IrType getIrType() {
    return IrType.VariableRefLinked;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
