/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import cfg.Flags;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;

public class Cdecl {
  static public HashSet<VariableName> getPreserves() {
    HashSet<VariableName> cdeclPreserves = new HashSet<VariableName>();
    cdeclPreserves.add(Registers.EBX);
    cdeclPreserves.add(Registers.ESI);
    cdeclPreserves.add(Registers.EDI);
    cdeclPreserves.add(Registers.EBP);
    cdeclPreserves.add(Registers.ESP);
    return cdeclPreserves;
  }

  // worst case
  public static Set<VariableName> getKilled() {
    HashSet<VariableName> killed = new HashSet<VariableName>();
    for (Registers r : Registers.values()) {
      killed.add(r);
    }
    for (Flags f : Flags.values()) {
      killed.add(f);
    }
    killed.removeAll(getPreserves());
    return killed;
  }

  public static List<VariableName> getReturns() {
    ArrayList<VariableName> cdeclReturns = new ArrayList<VariableName>();
    cdeclReturns.add(Registers.EAX);
    cdeclReturns.add(Registers.EDX);
    cdeclReturns.add(Registers.ST0);
    return cdeclReturns;
  }

}
