/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function;


import java.util.Collection;
import java.util.List;

import ast.type.Type;
import cfg.IrElement;
import cfg.variable.VariableName;

public abstract class Function implements IrElement {
  public abstract Collection<VariableName> getPreserves();
  public abstract List<VariableName> getReturns();
  public abstract Type getReturnType();
  public abstract List<FuncProtParam> getParam();
}
