/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import ast.type.Type;
import cfg.IrElement;
import cfg.IrType;
import cfg.variable.VariableName;

public class LibFunction extends Function {

  private final String                   name;
  private final boolean                  doesReturn;
  private final Type                     retType;
  private final ArrayList<FuncProtParam> param;

  public LibFunction(String name, ArrayList<FuncProtParam> param, boolean doesReturn, Type retType) {
    this.name = name;
    this.doesReturn = doesReturn;
    this.param = param;
    this.retType = retType;
  }

  public String getName() {
    return name;
  }

  public boolean doesReturn() {
    return doesReturn;
  }

  @Override
  public String toString() {
    return "'" + name + "'";
  }

  public IrType getIrType() {
    return IrType.FuncLibrary;
  }

  public List<? extends IrElement> getChildren() {
    return new ArrayList<IrElement>();
  }

  @Override
  public Collection<VariableName> getPreserves() {
    return Cdecl.getPreserves();
  }

  @Override
  public List<VariableName> getReturns() {
    return Cdecl.getReturns();
  }

  @Override
  public Type getReturnType() {
    return retType;
  }

  @Override
  public List<FuncProtParam> getParam() {
    return param;
  }
}
