/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function;


import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import ast.type.Type;
import cfg.IrElement;
import cfg.IrType;
import cfg.variable.VariableName;

public class SysFunction extends Function {

  private final String                   name;
  private final List<VariableName>       returns;
  private final Type                     retType;
  private final ArrayList<FuncProtParam> param;

  public SysFunction(String name, ArrayList<FuncProtParam> param, List<VariableName> returns, Type retType) {
    super();
    this.name = name;
    this.returns = returns;
    this.param = param;
    this.retType = retType;
  }

  @Override
  public String toString() {
    return name;
  }

  public String getName() {
    return name;
  }

  @Override
  public Collection<VariableName> getPreserves() {
    return new HashSet<VariableName>();
  }

  @Override
  public List<VariableName> getReturns() {
    return returns;
  }

  public IrType getIrType() {
    return IrType.FuncSystem;
  }

  public List<? extends IrElement> getChildren() {
    return new ArrayList<IrElement>();
  }

  @Override
  public Type getReturnType() {
    return retType;
  }

  @Override
  public List<FuncProtParam> getParam() {
    return param;
  }

}
