/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function.argument;


import java.util.Collection;

import cfg.IrItr;
import cfg.IrReplaceExprTraverser;
import cfg.expression.Expression;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefUnlinked;
import cfg.function.PrgFunction;
import cfg.matcher.VarIntopConstMatcher;
import cfg.variable.Variable;
import cfg.variable.VariablePtrDeref;

public class ArgumentPtrReplacer extends IrReplaceExprTraverser<Void> {

  private PrgFunction func = null;

  public static void process(Collection<PrgFunction> func) {
    ArgumentPtrReplacer replacer = new ArgumentPtrReplacer();
    replacer.visitCollection(func, null);
  }

  @Override
  protected void visitPrgFunction(PrgFunction obj, Void param) {
    assert (func == null);
    func = obj;
    super.visitPrgFunction(obj, param);
    assert (func == obj);
    func = null;
  }

  @Override
  protected Expression visitVariablePtrDeref(VariablePtrDeref obj, Void param) {
    VarIntopConstMatcher matcher = new VarIntopConstMatcher();
    matcher.parse(new IrItr(obj.getExpression()));
    if (!matcher.hasError()) {
      if (matcher.getVar() == FuncVariables.argPtr) {
        if (matcher.getOp() != IntegerOp.Add) {
          throw new RuntimeException("Expect addition");
        }
        if (matcher.getValue() < 0) {
          throw new RuntimeException("Expect positive offset");
        }
        if (matcher.getValue() % 4 != 0) {
          throw new RuntimeException("Expect 4 byte data types");
        }
        Variable var = func.getInternParam().get((int) matcher.getValue() / 4);
        return new VariableRefUnlinked(var.getName());
      }
    }
    return super.visitVariablePtrDeref(obj, param);
  }
}
