/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function.system;


import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ast.type.Type;
import cfg.function.FuncProtParam;
import cfg.function.SysFunction;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;

/**
 * this are functions to make the live more easy, e.g. abstract some functionality away
 * @author urs
 *
 */
public class SystemFunctions {
  public static final SysFunction push       = new SysFunction("push", makeParam("x", Type.Number), makeList(),Type.Void);
  public static final SysFunction pop        = new SysFunction("pop", new ArrayList<FuncProtParam>(), makeList(),Type.Number);
  public static final SysFunction halt       = new SysFunction("halt", new ArrayList<FuncProtParam>(), makeList(),Type.Void);
  public static final SysFunction castInt64  = new SysFunction("int64", makeParam("x", Type.Number), makeList(),Type.Number);
  public static final SysFunction funcMemcpy = new SysFunction("memcpy", null, makeList(Registers.ECX, Registers.EDI,
                                                 Registers.ESI),Type.Void);
  public static final SysFunction writeInt   = new SysFunction("writeInt", makeParam("value", Type.Number), makeList(),Type.Void);
  public static final SysFunction writeStr   = new SysFunction("writeStr", makeParam("text", Type.String), makeList(),Type.Void);
  public static final SysFunction writeNl    = new SysFunction("writeNl", new ArrayList<FuncProtParam>(), makeList(),Type.Void);
  public static final SysFunction readInt    = new SysFunction("readInt", new ArrayList<FuncProtParam>(), makeList(),Type.Integer);

  public static final SysFunction ptrNew     = new SysFunction("ptrMalloc", makeParam("size", Type.Integer), makeList(),Type.Pointer);
  public static final SysFunction ptrDestroy = new SysFunction("ptrFree", makeParam("ptr", Type.Pointer), makeList(),Type.Void);

  public Set<SysFunction> getAll() {
    Set<SysFunction> res = new HashSet<SysFunction>();
    res.add(push);
    res.add(pop);
    res.add(halt);
    res.add(castInt64);
    res.add(funcMemcpy);
    res.add(writeInt);
    res.add(writeStr);
    res.add(writeNl);
    res.add(readInt);
    return res;
  }

  private static ArrayList<FuncProtParam> makeParam(String name, Type type) {
    ArrayList<FuncProtParam> res = new ArrayList<FuncProtParam>(1);
    res.add(new FuncProtParam(name, type));
    return res;
  }

  private static List<VariableName> makeList(Registers reg1, Registers reg2, Registers reg3) {
    ArrayList<VariableName> ret = new ArrayList<VariableName>(3);
    ret.add(reg1);
    ret.add(reg2);
    ret.add(reg3);
    return ret;
  }

  private static List<VariableName> makeList() {
    return new ArrayList<VariableName>();
  }

}
