/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.linker;

import cfg.Application;
import cfg.IrTraverser;
import cfg.IrType;
import cfg.expression.VariableKilled;
import cfg.function.Function;
import cfg.function.PrgFunction;

/*
 * Adds the variables, killed by a function, to the function
 */
public class ReturnValueInserter extends IrTraverser<Void, Void> {

  public static void process(Application app) {
    ReturnValueInserter linker = new ReturnValueInserter();
    linker.visit(app.getFunctions(), null);
  }

  @Override
  protected Void visitVariableKilled(VariableKilled obj, Void param) {
    Function killer = obj.getKiller();
    assert (killer.getIrType() == IrType.FuncProgram);
    ((PrgFunction) killer).addReturnVariable(obj.getName());
    return null;
  }

}
