/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IntConstant;
import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRef;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;

public class ArrayIndexCalcMatcher extends Matcher {
  private VariableRef var;
  private Array       arr;

  public Array getArr() {
    return arr;
  }

  public VariableRef getVar() {
    return var;
  }

  @Override
  protected void doParse() {
    if (!removeToken(IrType.VariablePtrDeref)) {
      return;
    }
    if (!parseIntAdd()) {
      return;
    }
    checkForEnd();
  }

  private boolean parseIntAdd() {
    if (stream.peek().getIrType() != IrType.IntegerExpr) {
      doError(null, IrType.IntegerExpr);
      return false;
    }
    IntegerExpr expr = (IntegerExpr) stream.next();
    if (expr.getOp() != IntegerOp.Add) {
      doError(null, IntegerOp.Add);
      return false;
    }
    if (!parseIndex()) {
      return false;
    }
    return parseArray();
  }

  private boolean parseIndex() {
    if (stream.peek().getIrType() != IrType.IntegerExpr) {
      doError(null, IrType.IntegerExpr);
      return false;
    }
    IntegerExpr expr = (IntegerExpr) stream.next();
    if (expr.getOp() != IntegerOp.Mul) {
      doError(null, IntegerOp.Mul);
      return false;
    }

    if (!(stream.peek() instanceof VariableRef)) {
      doError(null, VariableRef.class);
      return false;
    }
    var = (VariableRef) stream.next();

    if (!(stream.peek() instanceof IntConstant)) {
      doError(null, IntConstant.class);
      return false;
    }
    IntConstant con = (IntConstant) stream.next();
    if (con.getValue() != 4) {
      doError("can not handle size of " + con.getValue(), 4);
      return false;
    }
    return true;
  }

  private boolean parseArray() {
    if (!removeToken(IrType.VariablePtrOf)) {
      return false;
    }

    if (!(stream.peek() instanceof ArrayAccess)) {
      doError(null, ArrayAccess.class);
      return false;
    }
    arr = ((ArrayAccess) stream.next()).getBase();

    if (!(stream.peek() instanceof IntConstant)) {
      doError(null, IntConstant.class);
      return false;
    }
    IntConstant con = (IntConstant) stream.next();
    if (con.getValue() != 0) {
      doError("can not handle size of " + con.getValue(), 0);
      return false;
    }
    return true;
  }

}
