/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;


import java.util.HashSet;
import java.util.Set;

import cfg.IrElement;
import cfg.IrItr;

public class MultiMatcher {
  private Set<? extends Matcher> matcher;
  
  public MultiMatcher(Set<? extends Matcher> matcher) {
    super();
    this.matcher = matcher;
  }

  public Set<? extends Matcher> match( IrElement root ){
    HashSet<Matcher>    res = new HashSet<Matcher>();
    for( Matcher i : matcher ){
      i.parse( new IrItr(root) );
      if( !i.hasError() ){
        res.add(i);
      }
    }
    return res;
  }
}
