/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;


import java.util.ArrayList;
import java.util.List;

import util.NumPrint;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import disassembler.diStorm3.DecomposedInst;

/**
 * 
 * @author urs
 * 
 *         Jumps to dst[expression] This means for boolean expressions: if expression jmp dst[1] else jmp dst[0]
 */
public class JumpStmt extends Statement {
  private Expression      expression;
  private ArrayList<Long> dst;

  public JumpStmt(long dst) {
    super();
    this.dst = new ArrayList<Long>();
    this.dst.add(dst);
    this.expression = new IntConstant(0);
  }

  public JumpStmt(int number, DecomposedInst original, long dst) {
    super(number, original);
    this.dst = new ArrayList<Long>();
    this.dst.add(dst);
    this.expression = new IntConstant(0);
  }

  public JumpStmt(int number, DecomposedInst original, Expression expression, ArrayList<Long> dst) {
    super(number, original);
    this.dst = dst;
    this.expression = expression;
  }

  public JumpStmt(int number, DecomposedInst original, Expression expression, long dst0) {
    super(number, original);
    this.dst = new ArrayList<Long>();
    this.dst.add(dst0);
    this.expression = expression;
  }

  public JumpStmt(int number, DecomposedInst original, Expression expression, long dst0, long dst1) {
    super(number, original);
    this.dst = new ArrayList<Long>();
    this.dst.add(dst0);
    this.dst.add(dst1);
    this.expression = expression;
  }

  public JumpStmt(Expression expression, long dst0, long dst1) {
    super();
    this.dst = new ArrayList<Long>();
    this.dst.add(dst0);
    this.dst.add(dst1);
    this.expression = expression;
  }

  public Expression getExpression() {
    return expression;
  }

  public void setExpression(Expression expression) {
    this.expression = expression;
  }

  public List<Long> getJmpDst() {
    return dst;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("jump( ");
    sb.append(expression);
    sb.append(", [");
    for (int i = 0; i < dst.size(); i++) {
      if (i > 0) {
        sb.append(", ");
      }
      sb.append(NumPrint.toString(dst.get(i)));
    }
    sb.append("] )");
    return sb.toString();
  }

  public IrType getIrType() {
    return IrType.JumpStmt;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>(1);
    res.add(expression);
    return res;
  }
}
