/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import util.NumPrint;
import cfg.Assignable;
import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.variable.SsaVariable;

public class PhiStmt extends Statement implements Assignment {
  private HashMap<Long, Expression> option = new HashMap<Long, Expression>();
  private SsaVariable               varname;

  public PhiStmt(SsaVariable varname) {
    this.varname = varname;
  }

  public void setVarname(SsaVariable varname) {
    this.varname = varname;
  }

  public SsaVariable getVarname() {
    return varname;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(varname);
    sb.append(" := phi( ");
    for (Long bb : option.keySet()) {
      sb.append(NumPrint.toString(bb));
      sb.append("::");
      sb.append(option.get(bb));
      sb.append("; ");
    }
    sb.append(")");
    return sb.toString();
  }

  public void addPredvar(Long pred, Expression ref) {
    assert (!option.containsKey(pred));
    option.put(pred, ref);
  }

  public HashMap<Long, Expression> getOption() {
    return option;
  }

  public List<Assignable> getDestination() {
    List<Assignable> res = new ArrayList<Assignable>(1);
    res.add(varname);
    return res;
  }

  public int getNumber() {
    return varname.getVersion();
  }

  public IrType getIrType() {
    return IrType.PhiStmt;
  }

  public List<? extends IrElement> getChildren() {
    return new ArrayList<IrElement>(option.values());
  }

}
