/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.variable.VariableName;
import disassembler.diStorm3.DecomposedInst;

public class RetStmt extends Statement {

  private Map<VariableName, Expression> retval;

  public RetStmt(int number, DecomposedInst original, Map<VariableName, Expression> retval) {
    super(number, original);
    this.retval = retval;
  }

  public Map<VariableName, Expression> getRetval() {
    assert (retval != null);
    return retval;
  }

  public void setRetval(Map<VariableName, Expression> retval) {
    this.retval = retval;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("return ");
    for (VariableName bb : retval.keySet()) {
      sb.append(bb);
      sb.append("::");
      sb.append(retval.get(bb));
      sb.append("; ");
    }
    return sb.toString();
  }

  public IrType getIrType() {
    return IrType.RetStmt;
  }

  public List<? extends IrElement> getChildren() {
    return new ArrayList<IrElement>(retval.values());
  }
}
