/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;

import cfg.IrElement;
import disassembler.diStorm3.DecomposedInst;

abstract public class Statement implements IrElement {
	private DecomposedInst						original;
	private int									number;
	private boolean								deleted = false;

	public Statement( int number, DecomposedInst original) {
		super();
		this.original = original;
		this.number = number;
	}
	
	public Statement() {
		super();
		this.original = null;
		this.number = -1;
	}
	
	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted() {
		this.deleted = true;
	}

	public int getNumber() {
		return number;
	}

	public DecomposedInst getOriginal() {
		return original;
	}
}
