/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.unlinker;


import java.util.Collection;

import cfg.IrElement;
import cfg.IrReplaceExprTraverser;
import cfg.expression.Expression;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;

public class VariableUnlinker extends IrReplaceExprTraverser<Void> {

  public static void unlink(Collection<? extends IrElement> obj) {
    VariableUnlinker unlinker = new VariableUnlinker();
    unlinker.visitCollection(obj, null);
  }

  @Override
  protected Expression visitVariableRefLinked(VariableRefLinked obj, Void param) {
    String name = obj.getReference().getName().toString();
    return new VariableRefUnlinked(new HllVariable(name));
  }

}
