/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.List;

import cfg.IrElement;
import cfg.IrType;

public class Array implements Variable {
  private VariableName name;
  private long         offset;
  private long         size;

  public Array(VariableName name, long offset, long size) {
    super();
    this.name = name;
    this.offset = offset;
    this.size = size;
  }

  public long getOffset() {
    return offset;
  }

  public void setName(VariableName name) {
    this.name = name;
  }

  public VariableName getName() {
    return name;
  }

  public long getSize() {
    return size;
  }

  @Override
  public String toString() {
    return name.toString();
  }

  public IrType getIrType() {
    return IrType.Array;
  }

  public List<? extends IrElement> getChildren() {
    throw new RuntimeException("Not yet implemented");
  }

}
