/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.LinkedList;
import java.util.List;

import util.NumPrint;
import cfg.IrElement;
import cfg.IrType;
import cfg.Memory;
import disassembler.diStorm3.Registers;

public class GlobalVariable implements Memory {
  private Registers segment;
  private long      address;

  public GlobalVariable(Registers segment, long address) {
    super();
    this.segment = segment;
    this.address = address;
  }

  public Registers getSegment() {
    return segment;
  }

  public long getAddress() {
    return address;
  }

  @Override
  public String toString() {
    return segment + ":" + NumPrint.toString(address);
  }

  public IrType getIrType() {
    return IrType.Memory;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
